<?php
defined('PF_VERSION') OR exit('Access denied');
function check_table_exits($db,$table){
    return $db->fetch_assoc($db->query('SHOW TABLES LIKE ?', array($table)));
}
function full_copy( $source, $target ) {
    if ( is_dir( $source ) ) {
        @mkdir( $target );
        $d = dir( $source );
        while ( FALSE !== ( $entry = $d->read() ) ) {
            if ( $entry == '.' || $entry == '..' ) {
                continue;
            }
            $Entry = $source . '/' . $entry;
            if ( is_dir( $Entry ) ) {
                full_copy( $Entry, $target . '/' . $entry );
                continue;
            }
            copy( $Entry, $target . '/' . $entry );
        }
        $d->close();
    }else {
        copy($source, $target);
    }
}
function active_plugin($plugin){
    $plugin_file = PLUGIN_PATH . '/' . $plugin;
    $plugin = explode ( '/', trim ( $plugin ) );
    if (is_array ( $plugin )) {
        $plugin_names = explode('-', $plugin [0]);
        $plugin_names = array_map('strtolower', $plugin_names);
        $plugin_names = array_map('ucfirst', $plugin_names);
        $class = implode('_', $plugin_names) . '_Plugin';
        if (! class_exists ( $class )) {
            require $plugin_file;
        }

        if (class_exists ( $class )) {
            $object = new $class ();
            if (method_exists ( $object, 'activate' )) {
                $object->activate ();
            }
        }
    }
}
function run_query1($file){
    $link = Pf::database()->get_link();
    $buffer = '';
    if (file_exists($file))
        $lines = file_get_contents($file);
    else {
        return false;
    }
    $result = @mysqli_query($link,$lines);
    return true;
}
function run_replate_url_content($rows){
    $db=Pf::database();
    if(is_array($rows['replate_url'])){
        foreach($rows['replate_url'] as $replate_url){
            $sql = "UPDATE ".$rows['table']." SET  `".$replate_url."` = REPLACE(`".$replate_url."`,'".URL_PAGEFLEX_DEV_MEDIA."','".URL_PAGEFLEX_MEDIA."')";
            $db->query($sql);
        }
    }else{
        $sql = "UPDATE ".$rows['table']." SET  `".$rows['replate_url']."` = REPLACE(`".$rows['replate_url']."`,'".URL_PAGEFLEX_DEV_MEDIA."','".URL_PAGEFLEX_MEDIA."')";
        $db->query($sql);
    }
}
function run_query($file){
    $link = Pf::database()->get_link();
    $buffer = '';
    if (file_exists($file))
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    else {
        return false;
    }
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (substr(ltrim($line), 0, 2) == '--' || $line[0] == '#')
            continue;
        if (($line = trim($line)) == '') {
            continue;
        } else if ($line[strlen($line) - 1] != ";") {
            $buffer .= $line;
            continue;
        } else{
            if ($buffer) {

                $line = $buffer . $line;
                $buffer = '';
            }
        }
        $result = @mysqli_query($link,$line);

    }
    return true;
}
function data_demodata(){

    return array(
        array(
            'func'=>'_copy_media',
            'icon'=>'fa fa-cog',
            'bg'=>'bg-lime',
            'label'=>'Copy Image',
            'description'=>'This is the Copy Image Data description',

        ),
        array(
            'func'=>'_options',
            'icon'=>'fa fa-cog',
            'bg'=>'bg-teal',
            'label'=>'Option',
            'description'=>'This is the Option Data description',

        ),
        array(
            'func'=>'_active_plugins',
            'icon'=>'fa fa-cogs',
            'bg'=>'bg-olive',
            'label'=>'Plugin',
            'description'=>'This is the Plugin Data description',

        ),
        array(
            'func'=>'_announcements',
            'icon'=>'fa fa-bell',
            'bg'=>'bg-aqua',
            'label'=>'Announcement',
            'description'=>'This is the Announcement Data description'
        ),
        array(
            'func'=>'_categories',
            'icon'=>'fa fa-plus-square',
            'bg'=>'bg-yellow',
            'label'=>'Categories',
            'description'=>'This is the Categories Data description'
        ),
        array(
            'func'=>'_galleries',
            'icon'=>'fa fa-camera',
            'label'=>'Galleries',
            'bg'=>'bg-purple',
            'description'=>'This is the Galleries Data description',
            'check_plugin'=>'pf_galleries'
        ),array(
            'func'=>'_pages',
            'icon'=>'fa fa-book',
            'label'=>'Pages',
            'bg'=>'bg-green',
            'description'=>'This is the Pages Data description'
        ),
        array(
            'func'=>'_portfolios',
            'icon'=>'fa fa-caret-square-o-right',
            'label'=>'Portfolios',
            'bg'=>'bg-maroon',
            'description'=>'This is the Portfolios Data description',
            'check_plugin'=>'pf_portfolios'
        ),
        array(
            'func'=>'_posts',
            'icon'=>'fa fa-edit',
            'label'=>'Posts',
            'bg'=>'bg-blue',
            'description'=>'This is the Posts Data description'
        ),
        array(
            'func'=>'_testimonials',
            'icon'=>'fa fa-thumbs-o-up',
            'label'=>'Testimonials',
            'bg'=>'bg-navy',
            'description'=>'This is the Testimonials Data description',
            'check_plugin'=>'pf_testimonials'
        )
    );
}
function process_copy_media(){
    full_copy(ABSPATH."/plugins/demodata/data/uploads",ABSPATH.'/uploads');
}
function process_active_plugins(){
    $db = Pf::database();
    $data = array(
        array(
            'name_plugin'=>'comment',
            'table_plugin'=>'pf_comments'
        ),
        array(
            'name_plugin'=>'rating',
            'table_plugin'=>'pf_ratings'
        ),
    );
    foreach($data as $rows){
        if(is_null(check_table_exits($db,$rows['table_plugin']))){
            active_plugin($rows['name_plugin']);
        }
    }
}
function process_testimonials($return=false){
    $db = Pf::database();
    $table_key = "pf_testimonials";
    if(is_null(check_table_exits($db,$table_key))){
        active_plugin("testimonials");
    }
        $data = array(
            'data'=> array(
                array(
                    'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/testimonials.sql',
                    'columns'=>array(5,1,2,3),
                    'table'=>'pf_testimonials'
                )
            ),
        );

        if($return){
            return $data;
        }
        $db = Pf::database();
        $sql = "TRUNCATE TABLE `pf_testimonials`;";
        $db->query($sql);
        foreach($data['data'] as $rows){
            run_query($rows['sql']);
        }

}
function process_options($return=false){

    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/pf_options.sql',
                'columns'=>array(5,1,2,3),
                'table'=>'pf_options'
            )
        ),
    );

    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "DROP TABLE pf_options;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
    }
}
function process_announcements($return=false){
    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/announcement.sql',
                'columns'=>array(5,1,2,3),
                'table'=>'pf_announcement'
           )
        ),
    );

    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "TRUNCATE TABLE `pf_announcement`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
    }
}
function process_categories($return=false){
    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/categories.sql',
                'columns'=>array(1,6,7),
                'table'=>'pf_categories'
           )
        )
    );
    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "TRUNCATE TABLE `pf_categories`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
    }
}
function process_galleries($return=false){
    $db = Pf::database();
    $table_key = "pf_galleries";

    if(is_null(check_table_exits($db,$table_key))){
        active_plugin("galleries");
    }
    $data = array(
        'data'=> array(array(
            'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/galleries.sql',
            'columns'=>array(1,6,7),
            'table'=>'pf_galleries'
           )
        )
    );
    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "TRUNCATE TABLE `pf_galleries`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
    }

}
function process_pages($return=false){
    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/pages.sql',
                'columns'=>array(1),
                'table'=>'pf_pages',
                'replate_url'=>array(
                    'page_content'
                )
            )
        )
    );
    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "TRUNCATE TABLE `pf_pages`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
        if(isset($rows['replate_url'])){
            run_replate_url_content($rows);
        }
    }
}
function process_portfolios($return=false){
    $db = Pf::database();
    $table_key = "pf_portfolios";
    if(is_null(check_table_exits($db,$table_key))){
        active_plugin("portfolio");
    }
    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/portfolios/portfolios.sql',
                'columns'=>array(1),
                'table'=>'pf_portfolios'
            ),
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/portfolios/portfolio_categories.sql',
                'columns'=>array(1),
                'table'=>'pf_portfolio_categories'
            ),
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/portfolios/portfolio_meta.sql',
                'columns'=>array(1),
                'replate'=>true,
                'table'=>'pf_portfolios'
            )
        )
    );
    if($return){
        return $data;
    }

    $sql = "TRUNCATE TABLE `pf_portfolio_meta`;";
    $db->query($sql);
    $sql = "TRUNCATE TABLE `pf_portfolios`;";
    $db->query($sql);
    $sql = "TRUNCATE TABLE `pf_portfolio_categories`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);

    }

}
function process_posts($return=false){
    $data = array(
        'data'=> array(
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/posts/posts.sql',
                'columns'=>array(1),
                'table'=>'pf_posts',
                'replate_url'=>array(
                    'post_content'
                )
            ),
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/posts/tags.sql',
                'columns'=>array(1),
                'table'=>'pf_tags'
            ),
            array(
                'sql'=>abs_plugin_path(__FILE__) . '/demodata/data/posts/post_tags.sql',
                'columns'=>array(1),
                'table'=>'pf_post_tags',
                'label'=>array(
                    1=>'Id'
                )
            )
        )
    );
    if($return){
        return $data;
    }
    $db = Pf::database();
    $sql = "TRUNCATE TABLE `pf_posts`;";
    $db->query($sql);
    $sql = "TRUNCATE TABLE `pf_tags`;";
    $db->query($sql);
    $sql = "TRUNCATE TABLE `pf_post_tags`;";
    $db->query($sql);
    foreach($data['data'] as $rows){
        run_query($rows['sql']);
        if(isset($rows['replate_url'])){
            run_replate_url_content($rows);
        }
    }
}
function get_columns_tr($str,$delimiter){
   preg_match_all("/VALUES(.*)/s", $str, $matches);
   return explode($delimiter,$matches[1][0]);
}